#ifndef _DIALOGS_TABPROCESSORS_CPP
#define _DIALOGS_TABPROCESSORS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <WindowsX.H>
#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <ShlOBJ.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabProcessorsDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND hCPUs = NULL;

	if(uMsg == WM_INITDIALOG)
    {
		char sRegBuf[255];
		char sTemp[255];

		DWORD dwRegBufSz = 0;
		float fCPUSpeed = 0;

		LV_COLUMN lvMyLVColumb;
		LV_ITEM lvMyLVItem;
		HIMAGELIST hMyImageList;

		memset(&lvMyLVColumb, 0, sizeof(lvMyLVColumb));
		memset(&lvMyLVItem, 0, sizeof(lvMyLVItem));
		memset(&hMyImageList, 0, sizeof(hMyImageList));

		hCPUs = GetDlgItem(hWnd, IDC_CPUS);

        SYSTEM_INFO SI;
        GetSystemInfo(&SI);
		
		int iLVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES;
        SendMessage(hCPUs, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

        // Create ImageList begin
        hMyImageList = ImageList_Create(GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), TRUE, 1, 1);

        HICON hIcon = NULL;

        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_SMCPU));
        ImageList_AddIcon(hMyImageList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        ListView_SetImageList(hCPUs, hMyImageList, LVSIL_SMALL);

        // Create Listview columbs
        lvMyLVColumb.cx        = 180;
        lvMyLVColumb.pszText   = "CPU";
        lvMyLVColumb.iSubItem  = 0;
        lvMyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        lvMyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hCPUs, 0, &lvMyLVColumb);

        lvMyLVColumb.cx        = 45;
        lvMyLVColumb.pszText   = "Model";
        lvMyLVColumb.iSubItem  = 1;
        lvMyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        lvMyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hCPUs, 1, &lvMyLVColumb);

        lvMyLVColumb.cx        = 55;
        lvMyLVColumb.pszText   = "Revision";
        lvMyLVColumb.iSubItem  = 2;
        lvMyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        lvMyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hCPUs, 2, &lvMyLVColumb);

        lvMyLVColumb.cx        = 65;
        lvMyLVColumb.pszText   = "Granularity";
        lvMyLVColumb.iSubItem  = 3;
        lvMyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        lvMyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hCPUs, 3, &lvMyLVColumb);

		/*
		dwRegBufSz = sizeof(sRegBuf);
		memset(sRegBuf, 0, dwRegBufSz);
		if(Get_StringRegistryValue(HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "VendorIdentifier", sRegBuf, dwRegBufSz))
			sprintf_s(sTemp, sizeof(sTemp), "\t Processor Type : %s ", sRegBuf);
		else sprintf_s(sTemp, sizeof(sTemp), "\t Processor Type : %s ", "N/A.");

		dwRegBufSz = sizeof(sRegBuf);
		memset(sRegBuf, 0, dwRegBufSz);
		if(Get_StringRegistryValue(HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "ProcessorNameString", sRegBuf, dwRegBufSz))
			sprintf_s(sTemp, sizeof(sTemp), "\t Processor Name : %s ", sRegBuf);
		else sprintf_s(sTemp, sizeof(sTemp), "\t Processor Name : %s ", "N/A.");

		dwRegBufSz = sizeof(sRegBuf);
		memset(sRegBuf, 0, dwRegBufSz);
		if(Get_StringRegistryValue(HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "Identifier", sRegBuf, dwRegBufSz))
			sprintf_s(sTemp, sizeof(sTemp), "\t Identifier : %s ", sRegBuf);
		else sprintf_s(sTemp, sizeof(sTemp), "\t Identifier : %s ", "N/A.");
		*/

		if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "~MHz", dwRegBufSz))
			dwRegBufSz = 0;

		fCPUSpeed = (float)dwRegBufSz;

		DWORD dwItem = 0;
        while(dwItem < SI.dwNumberOfProcessors)
        {
			dwRegBufSz = sizeof(sRegBuf);
			memset(sRegBuf, 0, dwRegBufSz);
			if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "VendorIdentifier", sRegBuf, dwRegBufSz))
				strcpy_s(sRegBuf, sizeof(sRegBuf), "Unkonwn");

			if(fCPUSpeed > 1000)
			{
				sprintf_s(sTemp, sizeof(sTemp), "%s %.1f0 GHz", sRegBuf, (fCPUSpeed / 1000.0f));
			}
			else sprintf_s(sTemp, sizeof(sTemp), "%s %.2f MHz", sRegBuf, fCPUSpeed);

			lvMyLVItem.pszText = sTemp;
            lvMyLVItem.mask = LVIF_TEXT|LVIF_IMAGE;
            lvMyLVItem.iImage = 0;
			lvMyLVItem.iItem = dwItem;
            lvMyLVItem.iSubItem = 0;
            ListView_InsertItem(hCPUs, &lvMyLVItem);

			sprintf_s(sTemp, sizeof(sTemp), "%d", HIWORD(SI.wProcessorRevision));
			lvMyLVItem.pszText = sTemp;
            lvMyLVItem.mask = LVIF_TEXT|LVIF_IMAGE;
            lvMyLVItem.iImage = 0;
			lvMyLVItem.iItem = dwItem;
            lvMyLVItem.iSubItem = 1;
            ListView_SetItem(hCPUs, &lvMyLVItem);

			sprintf_s(sTemp, sizeof(sTemp), "%d", LOWORD(SI.wProcessorRevision));
            lvMyLVItem.pszText = sTemp;
            lvMyLVItem.mask = LVIF_TEXT|LVIF_IMAGE;
            lvMyLVItem.iImage = 0;
			lvMyLVItem.iItem = dwItem;
            lvMyLVItem.iSubItem = 2;
            ListView_SetItem(hCPUs, &lvMyLVItem);

			sprintf_s(sTemp, sizeof(sTemp), "%0.2f K", ((float)SI.dwAllocationGranularity / 1024.0f));
            lvMyLVItem.pszText = sTemp;
            lvMyLVItem.mask = LVIF_TEXT|LVIF_IMAGE;
            lvMyLVItem.iImage = 0;
			lvMyLVItem.iItem = dwItem;
            lvMyLVItem.iSubItem = 3;
            ListView_SetItem(hCPUs, &lvMyLVItem);

			ListView_SetCheckState(hCPUs, dwItem, TRUE);

            dwItem++;
        }

		return TRUE;
    }

	if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
			return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
